/// \file DetectorConstruction.hh
/// \brief Definition of the DetectorConstruction class

#ifndef DetectorConstruction_h
#define DetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"

class G4VPhysicalVolume;
class G4GlobalMagFieldMessenger;

/// Detector construction class to define materials and geometry.
/// The calorimeter is a box made of a given number of layers. 
/// The layers are replicated.
///
/// The parameters that define the geometry of the calorimeter are:
/// - the thickness of a the scintillators,
/// - the number of layers,
/// - the transverse size of the calorimeter (the input face is a square).


class DetectorConstruction : public G4VUserDetectorConstruction
{
  public:
    DetectorConstruction();
    virtual ~DetectorConstruction();

  public:
    virtual G4VPhysicalVolume* Construct();

    // get methods
    const G4LogicalVolume* GetSciLV() const;
     
  private:
    // methods
    //
    void DefineMaterials();
    G4VPhysicalVolume* DefineVolumes();
  
    // data members
    //
    G4LogicalVolume*   fSciLV;      // the scintillator physical volume
    
    G4bool  fCheckOverlaps; // option to activate checking of volumes overlaps
};

// inline functions

inline const G4LogicalVolume* DetectorConstruction::GetSciLV() const  { 
  return fSciLV; 
}

#endif
