/// \file EventAction.hh
/// \brief Definition of the EventAction class

#ifndef EventAction_h
#define EventAction_h 1

#include "G4UserEventAction.hh"
#include "globals.hh"

/// Event action class

class EventAction : public G4UserEventAction
{
  public:
    EventAction();
    virtual ~EventAction();

    virtual void  BeginOfEventAction(const G4Event* event);
    virtual void    EndOfEventAction(const G4Event* event);
    
    void AddSci(G4double de, G4double dl);
    void AddLayer(G4int lay, G4double de);
    
  private:
    G4double  fEnergySci;
    G4double  fTrackLSci;
    G4double  fEnergyLayer[30];
};

// inline functions

inline void EventAction::AddSci(G4double de, G4double dl) {
  fEnergySci += de; 
  fTrackLSci += dl;
}

inline void EventAction::AddLayer(G4int lay, G4double de) {
  fEnergyLayer[lay] += de;
}

#endif

    