/// \file EventAction.cc
/// \brief Implementation of the EventAction class

#include "EventAction.hh"
#include "RunAction.hh"
//#include "Analysis.hh"
#include "g4root.hh"

#include "G4RunManager.hh"
#include "G4Event.hh"
#include "G4UnitsTable.hh"

#include "Randomize.hh"
#include <iomanip>

EventAction::EventAction()
 : G4UserEventAction(),
   fEnergySci(0.),
   fTrackLSci(0.)
{}

EventAction::~EventAction()
{}

void EventAction::BeginOfEventAction(const G4Event* /*event*/)
{  
  // initialisation per event
  fEnergySci = 0.;
  fTrackLSci = 0.;
  for (int i = 0; i < 30; i++) {
    fEnergyLayer[i] = 0.; 
  }
}

void EventAction::EndOfEventAction(const G4Event* /*event*/)
{
  // Accumulate statistics
  
  // get analysis manager
  G4AnalysisManager* analysisManager = G4AnalysisManager::Instance();

  // fill histograms
  analysisManager->FillH1(1, fEnergySci);
  analysisManager->FillH1(2, fTrackLSci);
  
  // fill ntuple
  analysisManager->FillNtupleDColumn(0, fEnergySci);
  analysisManager->FillNtupleDColumn(1, fTrackLSci);
  analysisManager->AddNtupleRow();
  
}  
